<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

/**
* Extends the CI session library to allow for VLER customizations.
* Additionally, some methods have been extended/overridden to include updates from CI v2.2, and several changes in an attempt to fix the race condition 
* error described here: http://www.hiretheworld.com/blog/tech-blog/codeigniter-session-race-conditions.
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class DPII_Session extends CI_Session {
	
	/**
	* True if cookie_httponly has been set to true in the config file.
	* When true, the session cookie will only be accessible when the application is using http(s) (vs ftp, etc.).
	* @var boolean
	*/
	var $cookie_httponly;

	/** Extends parent to take httponly cookie settings into account */
	public function __construct($params = array()) {
		$this->CI =& get_instance();
		$this->cookie_httponly = (isset($params['cookie_httponly'])) ? $params['cookie_httponly'] : $this->CI->config->item('cookie_httponly');
		parent::__construct($params);
	}
	
	/** Overrides parent to use the CI 2.2 version of the Session code - can be removed when we update to CI 2.2 */
	function sess_read(){		
		if(!array_key_exists($this->sess_cookie_name, $_COOKIE)){
			log_message('error', 'Session: No cookie found by name of '.$this->sess_cookie_name);
			return FALSE;			
		}		
	
		// Fetch the cookie
		if(!$this->sess_encrypt_cookie == TRUE)
			$session = $this->CI->input->cookie($this->sess_cookie_name);
		else
			$session = $_COOKIE[$this->sess_cookie_name]; //CI patched input so that it's not supposed sanitize this if encryption is on, but we're still getting a modified version occasionally, so just get it direct from $_COOKIE

		// No cookie?  Goodbye cruel world!...
		if(empty($session)){
			log_message('debug', 'A session cookie was not found.');
			return FALSE;
		}

		// HMAC authentication
		$len = strlen($session) - 40;

		if ($len <= 0){
			log_message('error', 'Session: The session cookie was not signed ($len was '.$len.')');
			return FALSE;
		}

		// Check cookie authentication
		$hmac = substr($session, $len);
		$session = substr($session, 0, $len);

		// Time-attack-safe comparison
		$hmac_check = hash_hmac('sha1', $session, $this->encryption_key);
		$diff = 0;

		//note that this code is just comparing each character and making sure they're the same.  
		//not sure why CI felt the need to write this as bitwise code instead of character comparisons, this seems a little unintuitive.  Plus, why don't we just break when we find a difference?
		for ($i = 0; $i < 40; $i++)
		{
			// ^ is the exclusive or operator operator in PHP: see http://php.net/manual/en/language.operators.bitwise.php
			//if $hmac[i] is the same as $hmac_check[i], $xor will be 0
			$xor = ord($hmac[$i]) ^ ord($hmac_check[$i]); 
			
			//|= is the same as $diff = ($diff|$xor) - $diff will stay 0 unless $hmac[$i] != $hmac_check[$i] at some point
			$diff |= $xor;
		}

		if ($diff !== 0)
		{
			log_message('error', 'Session: HMAC mismatch. The session cookie data did not match what was expected.');
			$this->sess_destroy();
			return FALSE;
		}

		// Decrypt the cookie data
		if ($this->sess_encrypt_cookie == TRUE)
		{
			$session = $this->CI->encrypt->decode($session);
		}

		// Unserialize the session array
		$session = $this->_unserialize($session);

		// Is the session data we unserialized an array with the correct format?
		if ( ! is_array($session) OR ! isset($session['session_id']) OR ! isset($session['ip_address']) OR ! isset($session['user_agent']) OR ! isset($session['last_activity']))
		{
			$this->sess_destroy();
			return FALSE;
		}

		// Is the session current?
		if (($session['last_activity'] + $this->sess_expiration) < $this->now)
		{
			$this->sess_destroy();
			return FALSE;
		}

		// Does the IP Match?
		if ($this->sess_match_ip == TRUE AND $session['ip_address'] != $this->CI->input->ip_address())
		{
			$this->sess_destroy();
			return FALSE;
		}

		// Does the User Agent Match?
		if ($this->sess_match_useragent == TRUE AND trim($session['user_agent']) != trim(substr($this->CI->input->user_agent(), 0, 120)))
		{
			$this->sess_destroy();
			return FALSE;
		}

		// Is there a corresponding session in the DB?
		if ($this->sess_use_database === TRUE)
		{
			
/* BEGIN RACE CONDITION FIX */
			$this->CI->db->where('(session_id = '.$this->CI->db->escape($session['session_id']).' OR last_session_id = '.$this->CI->db->escape($session['session_id']).')');			
			$this->CI->db->order_by('last_activity', 'desc');
			$this->CI->db->limit(1);
			$this->cookie_session_id = $session['session_id'];
/* END RACE CONDITION FIX */			

			if ($this->sess_match_ip == TRUE)
			{
				$this->CI->db->where('ip_address', $session['ip_address']);
			}

			if ($this->sess_match_useragent == TRUE)
			{
				$this->CI->db->where('user_agent', $session['user_agent']);
			}

			$query = $this->CI->db->get($this->sess_table_name);

			// No result?  Kill it!
			if ($query->num_rows() == 0)
			{
				$this->sess_destroy();
				return FALSE;
			}

			// Is there custom data?  If so, add it to the main session array
			$row = $query->row();
			if (isset($row->user_data) AND $row->user_data != '')
			{
				$custom_data = $this->_unserialize($row->user_data);

				if (is_array($custom_data))
				{
					foreach ($custom_data as $key => $val)
					{
						$session[$key] = $val;
					}
				}
			}
		
/* BEGIN RACE CONDITION FIX */		
			$session['session_id'] = $row->session_id;
			$session['last_session_id'] = $row->last_session_id;
/* END RACE CONDITION FIX*/
		}
		
		// Session is valid!
		$this->userdata = $session;
		unset($session);

		return TRUE; 
	}

	/** Overrides parent to allow for race condition changes. */
	function sess_write(){		
		// Are we saving custom data to the DB?  If not, all we do is update the cookie
		if ($this->sess_use_database === FALSE)
		{
			$this->_set_cookie();
			return;
		}

		// set the custom userdata, the session data we will set in a second
		$custom_userdata = $this->userdata;
		$cookie_userdata = array();

		// Before continuing, we need to determine if there is any custom data to deal with.
		// Let's determine this by removing the default indexes to see if there's anything left in the array
		// and set the session data while we're at it
		foreach (array('session_id','ip_address','user_agent','last_activity') as $val)
		{
			unset($custom_userdata[$val]);
			$cookie_userdata[$val] = $this->userdata[$val];
		}

/* BEGIN RACE CONDITION FIX */
		unset($custom_userdata['last_session_id']);
/* END RACE CONDITION FIX */

		// Did we find any custom data?  If not, we turn the empty array into a string
		// since there's no reason to serialize and store an empty array in the DB
		if (count($custom_userdata) === 0)
		{
			$custom_userdata = '';
		}
		else
		{
			// Serialize the custom data array so we can store it
			$custom_userdata = $this->_serialize($custom_userdata);
		}

		// Run the update query
		$this->CI->db->where('session_id', $this->userdata['session_id']);
		$this->CI->db->update($this->sess_table_name, array('last_activity' => $this->userdata['last_activity'], 'user_data' => $custom_userdata));

		// Write the cookie.  Notice that we manually pass the cookie data array to the
		// _set_cookie() function. Normally that function will store $this->userdata, but
		// in this case that array contains custom data, which we do not want in the cookie.
		$this->_set_cookie($cookie_userdata);
	}	
		
   
	/** Overrides parent to avoid updating sessions on AJAX calls - should help us avoid accidentally wiping the session */
	public function sess_update(){
		// We only update the session every five minutes by default
		if (($this->userdata['last_activity'] + $this->sess_time_to_update) >= $this->now)
		{
			return;
		}

		// _set_cookie() will handle this for us if we aren't using database sessions
		// by pushing all userdata to the cookie.
		$cookie_data = NULL;
		
/* BEGIN RACE CONDITION FIX */		
		/*
		* begin last_session_id_changes
		*
		* Don't need to regenerate the session if we came in by indexing to
		* the last_session_id), but send out the cookie anyway to make sure
		* that the client has a copy of the new cookie.
		*
		* Do an isset check first in case we're not using the database to
		* store extra data.  The last_session_id field only exists in the
		* database.
		*/
		if ((isset($this->userdata['last_session_id'])) && ($this->cookie_session_id === $this->userdata['last_session_id'])){
			// set cookie explicitly to only have our session data
			$cookie_data = array();
			foreach (array('session_id','ip_address','user_agent','last_activity') as $val){
				$cookie_data[$val] = $this->userdata[$val];
			}
		
			$this->_set_cookie($cookie_data);
			return;
		}
/* END RACE CONDITION FIX */
  
		// Save the old session id so we know which record to
		// update in the database if we need it
		$old_sessid = $this->userdata['session_id'];
		$new_sessid = '';
		while (strlen($new_sessid) < 32){
			$new_sessid .= mt_rand(0, mt_getrandmax());
		}

		// To make the session ID even more secure we'll combine it with the user's IP
		$new_sessid .= $this->CI->input->ip_address();

		// Turn it into a hash
		$new_sessid = md5(uniqid($new_sessid, TRUE));

		// Update the session data in the session data array
		$this->userdata['session_id'] = $new_sessid;
		$this->userdata['last_activity'] = $this->now;
				

		// Update the session ID and last_activity field in the DB if needed
		if ($this->sess_use_database === TRUE){			
			// set cookie explicitly to only have our session data
			$cookie_data = array();
			foreach (array('session_id','ip_address','user_agent','last_activity') as $val){
				$cookie_data[$val] = $this->userdata[$val];
			}

			$this->CI->db->query($this->CI->db->update_string($this->sess_table_name,	array('last_activity' => $this->now, 
																							  'session_id' => $new_sessid,
																							  'last_session_id' => $old_sessid), 
																							  array('session_id' => $old_sessid)));
			
/* BEGIN RACE CONDITION FIX */																								  
			if ($this->CI->db->affected_rows() === 0){
				$this->CI->db->where('last_session_id', $this->cookie_session_id);
				$this->CI->db->order_by('last_activity', 'DESC');
				$this->CI->db->limit(1);
				$query = $this->CI->db->get($this->sess_table_name);
			
				// We've lost track of the session if there are no results, so
				// don't set a cookie and just return.
				if ($query->num_rows() == 0){
					return;
				}
			
				$row = $query->row();
				foreach (array('session_id','ip_address','user_agent','last_activity') as $val){
					$this->userdata[$val] = $row->$val;
					$cookie_data[$val] = $this->userdata[$val];
				}
				
				// Set the request session id to the old session id so that we
				// won't try to regenerate the cookie again on this request --
				// just in case sess_update is ever called again (which it
				// shouldn't be).
				$this->cookie_session_id = $this->userdata['last_session_id'];
			}																								  
		}
/* END RACE CONDITION FIX */	

		// Write the cookie
		$this->_set_cookie($cookie_data);
	}
	
	/** Overrides parent to take {@link cookie_httponly} setting into account */		
	function sess_destroy(){
		// Kill the session DB row
		if ($this->sess_use_database === TRUE && isset($this->userdata['session_id']))
		{
			$this->CI->db->where('session_id', $this->userdata['session_id']);
			$this->CI->db->or_where('last_session_id', $this->userdata['session_id']);
			$this->CI->db->delete($this->sess_table_name);
		}

		// Kill the cookie
		setcookie(
					$this->sess_cookie_name,
					addslashes(serialize(array())),
					($this->now - 31500000),
					$this->cookie_path,
					$this->cookie_domain,
/* START HTTP-ONLY CUSTOMIZATION */					
					$this->cookie_secure,
					$this->cookie_httponly
/* END HTTP-ONLY CUSTOMIZATION */					
				);

		// Kill session data
		$this->userdata = array();
	}
	
	
	/** Overrides parent to set the httponly flag on the cookie if $this->cookie_http_only is set */
	function _set_cookie($cookie_data = NULL)
	{
		if (is_null($cookie_data))
		{
			$cookie_data = $this->userdata;
		}

		// Serialize the userdata for the cookie
		$cookie_data = $this->_serialize($cookie_data);

		if ($this->sess_encrypt_cookie == TRUE)
		{
			$cookie_data = $this->CI->encrypt->encode($cookie_data);
		}

		$cookie_data .= hash_hmac('sha1', $cookie_data, $this->encryption_key);
		$cookie_data_size = string_length_in_bytes($cookie_data);
		if($cookie_data_size/1000 > 4) log_message('error', 'Session userdata is greater than 4KB, which exceeds the capacity of the cookie.  Current size: '.$cookie_data_size.'B');

		$expire = ($this->sess_expire_on_close === TRUE) ? 0 : $this->sess_expiration + time();

		// Set the cookie
		setcookie(
					$this->sess_cookie_name,
					$cookie_data,
					$expire,
					$this->cookie_path,
					$this->cookie_domain,
					$this->cookie_secure,
/* START HTTP-ONLY CUSTOMIZATION */					
					$this->cookie_httponly
/* END HTTP-ONLY CUSTOMIZATION */
				);
	}			
	

	
	/**
	* Changes the system's idea of where we are in the inbox (drafts, sent messages, custom folders, etc.).
	* Should you need to accomplish this and reload the page, you can redirect to inbox/change_mailbox, but if 
	* this method will allow you to change the location in the session without doing a full redirect.
	* VLER method - does not override any methods in the parent class.
	* @param string|int Either the name of a location (inbox, draft, etc) or the numeric id of a custom folder
	*/
	function set_mailbox_location($location){
		//first - a couple actions we'll take care of no matter which location we're going to
		$_SESSION['page_start'] = 1; //bring user back to first page
		if(isset($_SESSION['filter_folder'])){unset($_SESSION['filter_folder']);}//remove archive filter
	

		//handle custom folders first so that we can default to inbox if we can't find the folder
		if(Folder::formatted_like_an_id($location)){
			$folder = Folder::find_one($location);
			
			if(Folder::is_an_entity($folder)){
				$_SESSION['folder'] = $location;
				$_SESSION['folder_name'] = $folder->name;
				return true; //we're done
			}
			
			//if we couldn't find the folder, trigger a warning and default to inbox
			$this->CI->error->warning($this->CI->error->describe($location).' is not a known folder, defaulting to inbox');
			$location = 'inbox';
		}
				
		//location names mapped to the display name
		$known_locations = array('inbox' => 'Inbox',
								 'sent' => 'Sent',
								 'draft' => 'Drafts',
								 'archived' => 'Archive');
		
		if(!array_key_exists($location, $known_locations)){
			$this->CI->error->warning($this->CI->error->describe($location).' is not a known folder, defaulting to inbox');
			$location = 'inbox';
		} 
		
		$_SESSION['folder'] = $location;
		$_SESSION['folder_name'] = $known_locations[$location];
		return true;
	}

	/**
	* Returns the current mailbox location, defaulting to inbox if not set.
	* @return string
	*/
	function mailbox_location(){
		if(empty($_SESSION['folder'])) $this->set_mailbox_location('inbox');
		return $_SESSION['folder'];
	}
	
	/**
	* Returns the display name of the current mailbox location, defaulting to Inbox if not set.
	* @return string
	*/
	function mailbox_location_display_name(){
		if(empty($_SESSION['folder_name'])) $this->set_mailbox_location($this->mailbox_location()); //will default to inbox if necessary, otherwise make sure display name for current folder is set
		return $_SESSION['folder_name'];
	}
	

	/**
	* Sets an error message in the flashdata, to be displayed the next time the page loads.
	* VLER method - does not override any methods in the parent class.
	* @param string
	*/	
	public function set_error_message($message){
		$this->set_flashdata('message',json_encode($message));
		$this->set_flashdata('message_class','error');
	}
	
	
	/**
	* Sets a service permission error in the flashdata, to be displayed the next time the page loads.
	* VLER method - does not override any methods in the parent class.
	* @param string 
	* @param string
	*/
	public function set_service_permission_error_message($service, $message){
		$this->session->set_flashdata('service_failure_due_to_permission',true);
		$this->session->set_flashdata('failed_service_name', json_encode($service));
		$this->session->set_flashdata('service_failure_due_to_permission_message',json_encode($message));       
	}
	
	/**
	* Sets a success feedback message in the flashdata, to be displayed the next time the page loads.
	* VLER method - does not override any methods in the parent class.
	* @param string
	*/
	public function set_success_message($message){
		$this->set_flashdata('message', json_encode($message));
		$this->set_flashdata('message_class','success');	
	}
} 